/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.recipe.provider;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;
import plus.dragons.createcentralkitchen.foundation.data.recipe.provider.Recipes;

public class DatapackRecipes
extends Recipes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<AbstractRegistrate<?>, Map<String, DatapackRecipes>> RECIPES = new HashMap();
    private static final Map<AbstractRegistrate<?>, ArrayListMultimap<String, Consumer<DatapackRecipes>>> EXTERNAL_RECIPES = new HashMap();
    protected final String name;

    public DatapackRecipes(String name, AbstractRegistrate<?> registrate, DataGenerator generator) {
        super(registrate, generator);
        this.name = name;
        DatapackRecipes.allFor(registrate).put(name, this);
        ArrayListMultimap<String, Consumer<DatapackRecipes>> external = DatapackRecipes.allExternalFor(registrate);
        if (external.containsKey((Object)name)) {
            external.get((Object)name).forEach(consumer -> consumer.accept(this));
        }
    }

    public static void addRecipe(AbstractRegistrate<?> registrate, String name, Consumer<DatapackRecipes> consumer) {
        DatapackRecipes.allExternalFor(registrate).put((Object)name, consumer);
    }

    public static <R extends IForgeRegistryEntry<R>, T extends R, P, B extends Builder<R, T, P, ?>> NonNullUnaryOperator<B> addRecipe(String modid, BiConsumer<DataGenContext<R, T>, Recipes> biConsumer) {
        return builder -> {
            DatapackRecipes.addRecipe(builder.getOwner(), modid, recipes -> biConsumer.accept((DataGenContext)DataGenContext.from((Builder)builder, (ResourceKey)builder.getRegistryKey()), (Recipes)((Object)recipes)));
            return builder;
        };
    }

    public static void buildAll(AbstractRegistrate<?> registrate, DataGenerator datagen) {
        Sets.SetView missing = Sets.difference((Set)DatapackRecipes.allExternalFor(registrate).keySet(), DatapackRecipes.allFor(registrate).keySet());
        for (String modId : missing) {
            datagen.m_123914_((DataProvider)new DatapackRecipes(modId, registrate, datagen));
        }
    }

    public static Map<String, DatapackRecipes> allFor(AbstractRegistrate<?> registrate) {
        return RECIPES.computeIfAbsent(registrate, it -> new HashMap());
    }

    public static ArrayListMultimap<String, Consumer<DatapackRecipes>> allExternalFor(AbstractRegistrate<?> registrate) {
        return EXTERNAL_RECIPES.computeIfAbsent(registrate, it -> ArrayListMultimap.create());
    }

    public void m_6865_(HashCache cache) {
        Path path = this.f_125970_.m_123916_().resolve("datapacks/" + this.name + "/data/");
        HashSet set = Sets.newHashSet();
        this.m_176531_(recipe -> {
            if (!set.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.m_6445_());
            }
            DatapackRecipes.saveRecipe(cache, recipe.m_125966_(), path.resolve(recipe.m_6445_().m_135827_() + "/recipes/" + recipe.m_6445_().m_135815_() + ".json"));
            JsonObject advancement = recipe.m_5860_();
            if (advancement != null) {
                this.m_126013_(cache, advancement, path.resolve(recipe.m_6445_().m_135827_() + "/advancements/" + recipe.m_6448_().m_135815_() + ".json"));
            }
        });
    }

    private static void saveRecipe(HashCache cache, JsonObject json, Path path) {
        try {
            String jsonString = GSON.toJson((JsonElement)json);
            String sha1 = f_123918_.hashUnencodedChars((CharSequence)jsonString).toString();
            if (!Objects.equals(cache.m_123938_(path), sha1) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(jsonString);
                }
            }
            cache.m_123940_(path, sha1);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)ioexception);
        }
    }
}

